% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_boundary.R
\name{define_boundary}
\alias{define_boundary}
\title{Define the boundary elements of a SpatRaster with numeric data or boundary intensities}
\usage{
define_boundary(x, threshold = 0.2, convert = FALSE)
}
\arguments{
\item{x}{A SpatRaster object.}

\item{threshold}{A value between 0 and 1. The proportion of cells to keep as boundary elements. default = 0.2.}

\item{convert}{logical. If TRUE, convert values of each cell from trait values to boundary intensities. default = FALSE.}
}
\value{
A SpatRaster object with cell values 1 for boundary elements and 0 for other cells
}
\description{
Defines boundaries in a SpatRaster object by keeping a proportion of the cells with the highest
boundary intensity values. If the SpatRaster contains trait values, the values can be converted
to boundary/edge values (convert = T) using a Sobel-Feldman operator.
}
\examples{
\donttest{
data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

grassland_boundaries <- define_boundary(grassland, 0.1)
}

}
\references{
Fortin, M.J. et al. (2000) Issues related to the detection of boundaries. Landscape Ecology, 15, 453-466.
Jacquez, G.M., Maruca,I S. & Fortin M.-J. (2000) From fields to objects: A review of geographic boundary analysis. Journal of Geographical Systems, 3, 221, 241.
}
\author{
Amy Luo
}
