% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_statistics.R
\name{max_subgraph}
\alias{max_subgraph}
\title{Length of the longest subgraph}
\usage{
max_subgraph(x, null_distrib)
}
\arguments{
\item{x}{A SpatRaster object with boundary elements.}

\item{null_distrib}{A list of probability functions output from boundary_null_distrib().}
}
\value{
The length of the longest subgraph and a p-value.
}
\description{
Statistical test for the length of the longest subgraph, or set of contiguous boundary elements.
}
\examples{
\donttest{
data(T.cristatus)
T.cristatus <- terra::rast(T.cristatus_matrix, crs = T.cristatus_crs)
terra::ext(T.cristatus) <- T.cristatus_ext

Tcrist_boundaries <- categorical_boundary(T.cristatus)
T.crist_bound_null <- boundary_null_distrib(T.cristatus, cat = TRUE, n_iterations = 100,
model = 'random_cluster')

max_subgraph(Tcrist_boundaries, T.crist_bound_null)
}

}
\references{
Jacquez, G.M., Maruca,I S. & Fortin M.-J. (2000) From fields to objects: A review of geographic boundary analysis. Journal of Geographical Systems, 3, 221, 241.
}
\author{
Amy Luo
}
