% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictValue.R
\name{predictValue}
\alias{predictValue}
\title{Genomic prediction}
\usage{
predictValue(sEnv = NULL, popID = NULL, trainingPopID = NULL,
  locations = NULL, years = NULL, sharingInfo = NULL, parms = NULL)
}
\arguments{
\item{sEnv}{the environment that BSL functions operate in. Default is "simEnv" so use that to avoid specifying when calling functions}

\item{popID}{population ID to be predicted (default: the latest population)}

\item{trainingPopID}{population ID to be used for training a prediction model (default: all populations with phenotype data). NOTE: if sharingInfo="none" this parameter has no effect.}

\item{locations}{data from which locations should be used (default: all locations)}

\item{years}{data from which years should be used (default: all years)}

\item{sharingInfo}{one of "none", "markers", "pedigree".  If none, genotypic values are assumed IID. If markers or pedigree, a genomic or pedigree relationship matrix is constructed}

\item{parms}{optional named list. Objects with those names will be created with the corresponding values. A way to pass values that are not predetermined by the script. Default: NULL}
}
\value{
modifies the list sims in environment sEnv by calculating predicted values as specified and changing the default selection criterion to use them
}
\description{
Genomic prediction
}
