% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_caiser.R
\name{print.CAISEr}
\alias{print.CAISEr}
\title{print.CAISEr}
\usage{
\method{print}{CAISEr}(x, ..., echo = TRUE, digits = 4, right = TRUE,
  breakrows = FALSE)
}
\arguments{
\item{x}{list object of class \emph{CAISEr}
(generated by \code{\link[=run_experiment]{run_experiment()}})}

\item{...}{other parameters to be passed down to specific
summary functions (currently unused)}

\item{echo}{logical flag: should the print method actually print to screen?}

\item{digits}{the minimum number of significant digits to be used.
See \code{\link[=print.default]{print.default()}}.}

\item{right}{logical, indicating whether or not strings should be
right-aligned.}

\item{breakrows}{logical, indicating whether to "widen" the output table by
placing the bottom half to the right of the top half.}
}
\value{
data frame object containing the summary table (invisibly)
}
\description{
S3 method for printing \emph{CAISEr} objects (the output of
\code{\link[=run_experiment]{run_experiment()}}).
}
\examples{
# Example using four dummy algorithms and 100 dummy instances.
# See [dummyalgo()] and [dummyinstance()] for details.
# Generating 4 dummy algorithms here, with means 15, 10, 30, 15 and standard
# deviations 2, 4, 6, 8.
algorithms <- mapply(FUN = function(i, m, s){
  list(FUN   = "dummyalgo",
       alias = paste0("algo", i),
       distribution.fun  = "rnorm",
       distribution.pars = list(mean = m, sd = s))},
  i = c(alg1 = 1, alg2 = 2, alg3 = 3, alg4 = 4),
  m = c(15, 10, 30, 15),
  s = c(2, 4, 6, 8),
  SIMPLIFY = FALSE)

# Generate 100 dummy instances with centered exponential distributions
instances <- lapply(1:100,
                    function(i) {rate <- runif(1, 1, 10)
                                 list(FUN   = "dummyinstance",
                                      alias = paste0("Inst.", i),
                                      distr = "rexp", rate = rate,
                                      bias  = -1 / rate)})

my.results <- run_experiment(instances, algorithms,
                             d = 1, se.max = .1,
                             power = .9, sig.level = .05,
                             power.target = "mean",
                             dif = "perc", comparisons = "all.vs.all",
                             seed = 1234, ncpus = 1)
my.results


}
