% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_param.R
\name{se_param}
\alias{se_param}
\title{Parametric standard errors}
\usage{
se_param(Xk, dif = "simple", comparisons = "all.vs.all", ...)
}
\arguments{
\item{Xk}{list object where each position contains a vector of observations
of algorithm k on a given problem instance.}

\item{dif}{name of the difference for which the SEs are desired.
Accepts "perc" (for percent differences) or "simple" (for simple
differences)}

\item{comparisons}{standard errors to be calculated. Accepts "all.vs.first"
(in which cases the first object in \code{algorithms} is considered to be
the reference algorithm) or "all.vs.all" (if there is no reference
and all pairwise SEs are desired).}

\item{...}{other parameters (used only for compatibility with calls to
\code{\link[=se_boot]{se_boot()}}, unused in this function)}
}
\value{
Data frame containing, for each pair of interest, the estimated
difference (column "Phi") and the sample standard error (column "SE")
}
\description{
Calculates the standard errors of a given statistic using parametric formulas
}
\section{References}{

\itemize{
\item E.C. Fieller:
Some problems in interval estimation. Journal of the Royal Statistical
Society. Series B (Methodological) 16(2), 175–185 (1954)
\item V. Franz:
Ratios: A short guide to confidence limits and proper use (2007).
https://arxiv.org/pdf/0710.2024v1.pdf
\item D.C. Montgomery, C.G. Runger:
Applied Statistics and Probability for Engineers, 6th ed. Wiley (2013)
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms. Journal of Heuristics 25(2):305-338, 2019.
}
}

\examples{
# three vectors of normally distributed observations
set.seed(1234)
Xk <- list(rnorm(10, 5, 1),  # mean = 5, sd = 1,
           rnorm(20, 10, 2), # mean = 10, sd = 2,
           rnorm(20, 15, 5)) # mean = 15, sd = 3

se_param(Xk, dif = "simple", comparisons = "all.vs.all")
se_param(Xk, dif = "perc", comparisons = "all.vs.first")
se_param(Xk, dif = "perc", comparisons = "all.vs.all")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br},
\email{f.campelo@aston.ac.uk})
}
