% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calf_wrappers.R
\name{calf_randomize}
\alias{calf_randomize}
\title{calf_randomize}
\usage{
calf_randomize(data, nMarkers, randomize = TRUE, times = 1)
}
\arguments{
\item{data}{Matrix or data frame. First column must contain case/control dummy coded variable; all other columns contain relevant markers}

\item{nMarkers}{Maximum number of markers to include in creation of sum}

\item{randomize}{Logical. Indicate TRUE to randomize the case/control status of each individual. Used to compare results from true data with results from randomized data.}

\item{times}{Numeric. Indicates the number of replications to run with randomization.}
}
\value{
A data frame containing the chosen markers and their assigned weight (-1 or 1)

The AUC value for the classification

aucHist A histogram of the AUCs across replications.
}
\description{
Coarse approximation linear function, randomized
}
\examples{
calf_randomize(data = CaseControl, nMarkers = 6, randomize = TRUE, times = 5)
}

