% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{av_out}
\alias{av_out}
\title{Averaging out the predictive power}
\usage{
av_out(preds,crv,k)
}
\arguments{
\item{preds}{An M x \code{crv}N matrix consisting of \code{crv} horizontally concatenated M x N matrices. These M x N matrices are the matrices of predictive powers for all feasible regressions (M is maximum feasible number of variables included in a regression, N is the maximum feasible number of regressions of the fixed size; the row index indicates the number of variables included in a regression)}

\item{crv}{number of cross-validations}

\item{k}{size of the test set for which the predictions are made}
}
\value{
Returns an M x N matrix of average predictive powers where M is maximum feasible number of variables included in a regression, N is the maximum feasible number of regressions of the fixed size; the row index indicates the number of variables included in a regression
}
\description{
Function which averages out the predictive power over all cross-validations
}
\examples{
#creating a matrix of predictive powers

preds<-cbind(matrix(runif(40,1,4),ncol=10),matrix(runif(40,1.5,4),ncol=10))
preds<-cbind(preds,matrix(runif(40,1,3.5),ncol=10))

#running the function

av_out(preds,3,5)
}
