% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cbtf}
\alias{summary.cbtf}
\title{Results summary from a fuzz run}
\usage{
\method{summary}{cbtf}(object, ...)
}
\arguments{
\item{object}{An object of class \code{cbtf}.}

\item{...}{Further arguments passed to or from other methods.
These are currently ignored.}
}
\value{
A data frame containing the following columns and attributes is returned
invisibly:
\item{fun}{The names of the function tested.}
\item{what}{The inputs tested.}
\item{res}{One of "OK", "FAIL", "WARN" or "SKIP" for each combination of
function and input tested (see the \emph{Value} section in \link{fuzz}).}
\item{msg}{The message received in case of error, warning or skip,
or an empty string if no failure occurred.}
\item{attr(*, "summary_table")}{The tabulation of results that was printed
out.}
}
\description{
Reports some summary statistics from the results of a run of \link{fuzz}.
}
\examples{
res <- fuzz(funs = c("list", "matrix", "mean"),
            what = test_inputs(c("numeric", "raw")))
summary(res)

}
\seealso{
\link{print.cbtf}
}
