% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Cscale.R
\name{add_Cscale}
\alias{add_Cscale}
\title{Add a color scale}
\usage{
add_Cscale(
  pos = "1/1",
  title = "Depth (m)",
  width = 18,
  height = 70,
  cuts = Depth_cuts,
  cols = Depth_cols,
  minVal = NA,
  maxVal = NA,
  fontsize = 1,
  offset = 100,
  lwd = 1,
  mode = "Cscale"
)
}
\arguments{
\item{pos}{character, fraction indicating the vertical position of the color scale (which, by default, is on the 
right side of plots). if \code{pos="1/1"}, the color scale will be centered. 
if \code{pos="1/2"}, the color scale will be centered on the top half of the plotting region.
if \code{pos="2/2"}, the color scale will be centered on the bottom half of the plotting region.}

\item{title}{character, title of the color scale.}

\item{width}{numeric, width of the color scale box, expressed in \% of the width of the plotting region.}

\item{height}{numeric, height of the color scale box, expressed in \% of the height of the plotting region.}

\item{cuts}{numeric, vector of color classes. May be generated via \code{\link{add_col}}.}

\item{cols}{character, vector of color names. May be generated via \code{\link{add_col}}.}

\item{minVal}{numeric, if desired, the color scale may be generated starting from the value \code{minVal}. See examples.}

\item{maxVal}{numeric, if desired, the color scale may be generated up to the value \code{maxVal}. See examples.}

\item{fontsize}{numeric, size of the text in the color scale.}

\item{offset}{numeric, controls the horizontal position of the color scale.}

\item{lwd}{numeric, thickness of lines.}

\item{mode}{character, if 'Cscale', the default, the function builds a color scale. if 'Legend', the function
gives you the location of a \code{\link[graphics]{legend}}, arguments \code{pos}, \code{offset} and \code{height}
may be used for adjustments. See examples.}
}
\description{
Adds a color scale to plots. Default behavior set for bathymetry. May also be used to 
place a \code{\link[graphics]{legend}}.
}
\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#5-adding-colors-legends-and-labels


#Example 1: Adding two color scales

plot(SmallBathy,breaks=Depth_cuts,col=Depth_cols,legend=FALSE,axes=FALSE,box=FALSE)
add_Cscale(pos='1/2',height=45,maxVal=0,minVal=-4000,fontsize=0.8)
#Some gridded data
MyGrid=create_PolyGrids(GridData,dlon=2,dlat=1)
Gridcol=add_col(MyGrid$Catch_sum,cuts=10)
plot(st_geometry(MyGrid),col=Gridcol$varcol,add=TRUE)
#Add color scale using cuts and cols generated by add_col, note the use of 'round'
add_Cscale(pos='2/2',height=45,title='Catch (t)',
           cuts=round(Gridcol$cuts,1),cols=Gridcol$cols,fontsize=0.8)

#Example 2: Adding a color scale and a legend

#Create some point data
MyPoints=create_Points(PointData)

#Crop the bathymetry to match the extent of MyPoints 
library(terra)
BathyCr=crop(rast(SmallBathy),extend(ext(MyPoints),100000))
plot(BathyCr,breaks=Depth_cuts,col=Depth_cols,legend=FALSE,axes=FALSE,mar=c(0,0,0,7))
add_Cscale(pos='1/2',height=45,maxVal=0,minVal=-4000,fontsize=0.8)

#Plot points with different symbols and colors (see ?points)
Psymbols=c(21,22,23,24)
Pcolors=c('red','green','blue','yellow')
plot(st_geometry(MyPoints[MyPoints$name=='one',]),pch=Psymbols[1],bg=Pcolors[1],add=TRUE)
plot(st_geometry(MyPoints[MyPoints$name=='two',]),pch=Psymbols[2],bg=Pcolors[2],add=TRUE)
plot(st_geometry(MyPoints[MyPoints$name=='three',]),pch=Psymbols[3],bg=Pcolors[3],add=TRUE)
plot(st_geometry(MyPoints[MyPoints$name=='four',]),pch=Psymbols[4],bg=Pcolors[4],add=TRUE)

#Add legend with position determined by add_Cscale
Loc=add_Cscale(pos='2/2',height=45,mode='Legend')
legend(Loc,legend=c('one','two','three','four'),title='Vessel',pch=Psymbols,
pt.bg=Pcolors,xpd=TRUE)

}
\seealso{
\code{\link{load_Bathy}}, \code{\link{SmallBathy}}, \code{\link{Depth_cuts}}, \code{\link{Depth_cols}}, 
\code{\link{Depth_cuts2}}, \code{\link{Depth_cols2}}, \code{\link{add_col}},
\href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{R colors}, \code{\link[graphics]{legend}}.
}
