\name{BiCopPar2Tau}      
\alias{BiCopPar2Tau} 

\title{Kendall's tau value of a bivariate copula}

\description{
This function computes the theoretical Kendall's tau value of a bivariate copula for given parameter values. 
}

\usage{
BiCopPar2Tau(family, par, par2=0)
}

\arguments{
  \item{family}{An integer defining the bivariate copula family:\cr
		\code{0} = independence copula \cr
	        \code{1} = Gaussian copula \cr
	        \code{2} = Student t copula (t-copula) \cr
	        \code{3} = Clayton copula \cr
	        \code{4} = Gumbel copula \cr
	        \code{5} = Frank copula \cr
	        \code{6} = Joe copula \cr 
		\code{7} = BB1 copula \cr
		\code{8} = BB6 copula \cr
		\code{9} = BB7 copula \cr
		\code{10} = BB8 copula \cr
		\code{13} = rotated Clayton copula (180 degrees; ``survival Clayton'') \cr
		\code{14} = rotated Gumbel copula (180 degrees; ``survival Gumbel'') \cr
		\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr 
		\code{17} = rotated BB1 copula (180 degrees; ``survival BB1'')\cr
		\code{18} = rotated BB6 copula (180 degrees; ``survival BB6'')\cr
		\code{19} = rotated BB7 copula (180 degrees; ``survival BB7'')\cr
		\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
		\code{23} = rotated Clayton copula (90 degrees) \cr
		\code{24} = rotated Gumbel copula (90 degrees) \cr
		\code{26} = rotated Joe copula (90 degrees) \cr
		\code{27} = rotated BB1 copula (90 degrees) \cr
		\code{28} = rotated BB6 copula (90 degrees) \cr
		\code{29} = rotated BB7 copula (90 degrees) \cr
		\code{30} = rotated BB8 copula (90 degrees) \cr
		\code{33} = rotated Clayton copula (270 degrees) \cr
		\code{34} = rotated Gumbel copula (270 degrees) \cr
		\code{36} = rotated Joe copula (270 degrees) \cr
		\code{37} = rotated BB1 copula (270 degrees) \cr
		\code{38} = rotated BB6 copula (270 degrees) \cr
		\code{39} = rotated BB7 copula (270 degrees) \cr
		\code{40} = rotated BB8 copula (270 degrees) 
		}
  \item{par}{Copula parameter.}
  \item{par2}{Second parameter for the two parameter BB1, BB6, BB7 and BB8 copulas (default: \code{par2 = 0}).
    Note that the degrees of freedom parameter of the t-copula does not need to be set,
    because the theoretical Kendall's tau value of the t-copula is independent of this choice.}
}                                                                                  

\value{
Theoretical value of Kendall's tau corresponding to the bivariate copula family and parameter(s)
(\eqn{\theta} for one parameter families and the first parameter of the t-copula,
\eqn{\theta} and \eqn{\delta} for the two parameter BB1, BB6, BB7 and BB8 copulas). 
\tabular{ll}{
No. \tab Kendall's tau \cr
\code{1, 2} \tab \eqn{\frac{2}{\pi}\arcsin(\theta)}{2 / \pi arcsin(\theta)} \cr
\code{3, 13} \tab \eqn{\frac{\theta}{\theta+2}}{\theta / (\theta+2)} \cr
\code{4, 14} \tab \eqn{1-\frac{1}{\theta}}{1-1/\theta} \cr
\code{5} \tab \eqn{1-\frac{4}{\theta}+4\frac{D_1(\theta)}{\theta}}{1-4/\theta + 4 D_1(\theta)/\theta} \cr
	 \tab with \eqn{D_1(\theta)=\int_0^\theta \frac{c/\theta}{\exp(x)-1}dx}{D_1(\theta)=\int_0^\theta (c/\theta)/(exp(x)-1)dx} (Debey function) \cr
\code{6, 16} \tab \eqn{1+\frac{4}{\theta^2}\int_0^1 x\log(x)(1-x)^{2(1-\theta)/\theta}dx}{1+4/\theta^2\int_0^1 x\log(x)(1-x)^{2(1-\theta)/\theta}dx} \cr
\code{7, 17} \tab \eqn{1-\frac{2}{\delta(\theta+2)}}{1-2/(\delta(\theta+2))} \cr
\code{8, 18} \tab \eqn{1+4\int_0^1 -\log(-(1-t)^\theta+1)(1-t-(1-t)^{-\theta}+(1-t)^{-\theta}t)/(\delta\theta) dt} \cr
\code{9, 19} \tab \eqn{1-\frac{2}{\delta(2-\theta)}+\frac{4}{\theta^2 \delta}B(\frac{2-\theta}{\theta},\delta+2)}{1-2/(\delta(2-\theta)) + 4/(\theta^2 \delta) B((2-\theta)/\theta , \delta+2)} \cr
	 \tab with \eqn{B(x,y)=\int_0^1 t^{x+1}(t-1)^{y-1}dt} (Beta function) \cr
\code{10, 20} \tab \eqn{1+4\int_0^1 -\log \left( ((1-t\delta)^\theta-1)/((1-\delta)^\theta-1) \right) } \cr
	 \tab \eqn{* (1-t\delta-(1-t\delta)^{-\theta}+(1-t\delta)^{-\theta}t\delta)/(\theta\delta) dt} \cr
\code{23, 33} \tab \eqn{\frac{\theta}{-\theta+2}}{\theta/(-\theta+2)} \cr
\code{24, 34} \tab \eqn{-1-\frac{1}{\theta}}{-1-1/\theta} \cr
\code{26, 36} \tab \eqn{-1-\frac{4}{\theta^2}\int_0^1 x\log(x)(1-x)^{-2(1+\theta)/\theta}dx}{-1-4/\theta^2\int_0^1 x\log(x)(1-x)^{-2(1+\theta)/\theta}dx} \cr
\code{27, 37} \tab \eqn{-1+\frac{2}{\delta(\theta+2)}}{1-2/(\delta(\theta+2))} \cr
\code{28, 38} \tab \eqn{-1-4\int_0^1 -\log(-(1-t)^\theta+1)*(1-t-(1-t)^{-\theta}+(1-t)^{-\theta}t)/(\delta\theta) dt} \cr
\code{29, 39} \tab \eqn{-1+\frac{2}{\delta(2-\theta)}+\frac{4}{\theta^2 \delta}B(\frac{2-\theta}{\theta},\delta+2)}{1-2/(\delta(2-\theta)) + 4/(\theta^2 \delta) B((2-\theta)/\theta , \delta+2)} \cr
	 \tab with \eqn{B(x,y)=\int_0^1 t^{x+1}(t-1)^{y-1}dt} (Beta function) \cr
\code{30, 40} \tab \eqn{-1-4\int_0^1 -\log \left( ((1-t\delta)^\theta-1)/((1-\delta)^\theta-1) \right)} \cr 
	 \tab \eqn{* (1-t\delta-(1-t\delta)^{-\theta}+(1-t\delta)^{-\theta}t\delta)/(\theta\delta) dt} \cr
}
}

\author{Ulf Schepsmeier}

\references{
Joe, H. (1997).
Multivariate Models and Dependence Concepts.
Chapman and Hall, London.

Czado, C., U. Schepsmeier, and A. Min (2011).
Maximum likelihood estimation of mixed C-vines with application to exchange rates.
Statistical Modelling, to appear.
}

\seealso{\code{\link{CDVinePar2Tau}}, \code{\link{BiCopTau2Par}}}

\examples{
## Example 1: Gaussian copula
tt1 = BiCopPar2Tau(1,0.7)

# transform back
BiCopTau2Par(1,tt1)


## Example 2: Clayton copula
BiCopPar2Tau(3,1.3)
}

