% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{downsampling}
\alias{downsampling}
\title{Downsampling cells}
\usage{
downsampling(
  metadata,
  n.size = 35,
  seed = 12345,
  include = FALSE,
  replace = FALSE,
  lower.cutoff = 3
)
}
\arguments{
\item{metadata}{Data frame. It includes at least 2 columns, label and batch.
Each row corresponds to one cell. Required.}

\item{n.size}{Numeric. The number of cells used in each group. (Default: 35)}

\item{seed}{Numeric. Seed used to sample. (Default: 12345)}

\item{include}{Boolean. Using `include = TRUE` to include the group smaller
than required size. (Default: FALSE)}

\item{replace}{Boolean. Using `replace = TRUE` if the group is smaller than
required size and some cells will be repeatedly used. (Default: FALSE)}

\item{lower.cutoff}{Numeric. The minimum size of groups to keep.
(Default: 3)}
}
\value{
A numeric list of which cells will be kept for downstream
computation.
}
\description{
Downsampling cells from each group for IDER-based similarity
calculation.
}
