% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalClustering.R
\name{finalClustering}
\alias{finalClustering}
\title{Final clustering step for meta-clustering}
\usage{
finalClustering(
  seu,
  dist,
  cutree.by = "h",
  cutree.h = 0.45,
  cutree.k = 3,
  hc.method = "complete"
)
}
\arguments{
\item{seu}{Seurat S4 object after the step of `getIDEr`. Required.}

\item{dist}{A list. Output of `getIDEr`. Required.}

\item{cutree.by}{Character. Cut the tree by which parameter, height ("h") or
number of clusters ("k"). (Default: h)}

\item{cutree.h}{Numeric between 0 and 1. The height used to cut the tree.
Ignored if `cutree.by = 'k`. (Default: 0.45)}

\item{cutree.k}{Numeric/integer. Used to cut the tree. Ignored if
`cutree.by = 'h`. (Default: 3)}

\item{hc.method}{Character. Used to choose the hierarchical
clustering method.}
}
\value{
Seurat S4 object with final clustering results in `CIDER_clusters`
of meta.data.
}
\description{
Merge initial clusters into final clusters based on the
matrix of IDEr.
}
\examples{
library(CIDER)
data("pancreas")
ider <- getIDEr(pancreas, downsampling.size = 30)
seu <- finalClustering(pancreas, ider)
head(seu$CIDER_cluster)
}
\seealso{
\code{\link{getIDEr}}.
}
