% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_towers.R
\name{financial_cof_towers}
\alias{financial_cof_towers}
\title{Financial cost of Failure for Towers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
financial_cof_towers(
  tower_asset_category,
  type_financial_factor_criteria,
  access_factor_criteria
)
}
\arguments{
\item{tower_asset_category}{String The type of Pole asset category}

\item{type_financial_factor_criteria}{String The type financial factor for Tower}

\item{access_factor_criteria}{String. Asses Financial factor criteria for Pole
setting (cf. table 214, page 164, CNAIM, 2017).}
}
\value{
Numeric. Financial consequences of failure for Poles
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_towers(tower_asset_category = "33kV Tower",
type_financial_factor_criteria = "Suspension",
access_factor_criteria = "Type A")
}
