% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_ehv_fittings.R
\name{environmental_cof_ehv_fittings}
\alias{environmental_cof_ehv_fittings}
\title{Environmental cost of Failure for EHV/132kV fittings}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
environmental_cof_ehv_fittings(ehv_asset_category)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV asset category
Options: \code{ehv_asset_category = c("33kV Fittings", "66kV Fittings",
 "132kV Fittings")}}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV switchgear
}
\examples{
environmental_cof_ehv_fittings(ehv_asset_category = "33kV Fittings")
}
