% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_regen.R
\name{indChange}
\alias{indChange}
\title{Add and remove indicators}
\usage{
indChange(COIN, add = NULL, drop = NULL, regen = FALSE)
}
\arguments{
\item{COIN}{COIN object}

\item{add}{A character vector of indicator codes to add (must be present in the original input data)}

\item{drop}{A character vector of indicator codes to remove (must be present in the original input data)}

\item{regen}{Logical (default): if \code{TRUE}, automatically regenerates the results based on the new specs
Otherwise, just updates the \code{.$Method$assemble} parameters. This latter might be useful if you want to
Make other changes before re-running using the \code{\link[=regen]{regen()}} function.}
}
\value{
An updated COIN, with regenerated results if \code{regen = TRUE}.
}
\description{
A shortcut function to add and remove indicators. This will make the relevant changes
and recalculate the index if asked. Adding and removing is done relative to the current set of
indicators used in calculating the index results. Any indicators that are added must of course be
present in \code{.$Input$Original} (in both \code{IndData} and \code{IndMeta}).
}
\examples{
# build ASEM example
ASEM <- build_ASEM()
# remove one indicator and regenerate results
ASEM2 <- indChange(ASEM, drop = "UNVote", regen = TRUE)
# compare the differences
CT <- compTable(ASEM, ASEM2, dset = "Aggregated", isel = "Index")

}
\seealso{
\itemize{
\item \code{\link[=regen]{regen()}} regenerate a COIN
\item \code{\link[=compTable]{compTable()}} compare two different COINs
\item \code{\link[=compTableMulti]{compTableMulti()}} compare multiple COINs
}
}
