% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_aggregate.R
\name{geoMean_rescaled}
\alias{geoMean_rescaled}
\title{Rescaled weighted geometric mean}
\usage{
geoMean_rescaled(x, w = NULL)
}
\arguments{
\item{x}{A numeric vector of positive values.}

\item{w}{A vector of weights, which should have length equal to \code{length(x)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}
}
\value{
Rescaled weighted geometric mean, as a numeric value.
}
\description{
\emph{NOTE this function is not really in use but is kept here for the moment. Not sure it is very useful.}
}
\details{
Weighted geometric mean of a vector. Here, any zero or negative values are automatically dealt with
by re-scaling the data to be all positive, i.e. it shifts so that the minimum is equal to 0.1.

Note that this could be better achieved by normalising first. However, following default normalisation
between 0 and 100, this function offers a quick way to test the effect of a geometric mean, for example in
a sensitivity analysis, and avoids bugs arising.
}
\examples{
# a vector of values
x <- 1:10
# a vector of weights
w <- runif(10)
# rescaled weighted geometric mean
geoMean_rescaled(x,w)

}
