% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_coin.R
\name{check_iMeta}
\alias{check_iMeta}
\title{Check iMeta}
\usage{
check_iMeta(iMeta, quietly = FALSE)
}
\arguments{
\item{iMeta}{A data frame of indicator metadata. See details.}

\item{quietly}{Set \code{TRUE} to suppress message if input is valid.}
}
\value{
Message if everything ok, else error messages.
}
\description{
Checks the format of \code{iMeta} input to \code{\link[=new_coin]{new_coin()}}. This performs a series of thorough checks to make sure
that \code{iMeta} agrees with the specifications. This also includes checks to make sure the structure makes
sense, there are no duplicates, and other things. \code{iMeta} must pass this check to build a new coin.
}
\details{
Required columns for \code{iMeta} are:
\itemize{
\item \code{Level}: Level in aggregation, where 1 is indicator level, 2 is the level resulting from aggregating
indicators, 3 is the result of aggregating level 2, and so on. Set to \code{NA} for entries that are not included
in the index (groups, denominators, etc).
\item \code{iCode}: Indicator code, alphanumeric. Must not start with a number.
\item \code{Parent}: Group (\code{iCode}) to which indicator/aggregate belongs in level immediately above.
Each entry here should also be found in \code{iCode}. Set to \code{NA} only
for the highest (Index) level (no parent), or for entries that are not included
in the index (groups, denominators, etc).
\item \code{Direction}: Numeric, either -1 or 1
\item \code{Weight}: Numeric weight, will be rescaled to sum to 1 within aggregation group. Set to \code{NA} for entries that are not included
in the index (groups, denominators, etc).
\item \code{Type}: The type, corresponding to \code{iCode}. Can be either \code{Indicator}, \code{Aggregate}, \code{Group}, \code{Denominator},
or \code{Other}.
}

Optional columns that are recognised in certain functions are:
\itemize{
\item \code{iName}: Name of the indicator: a longer name which is used in some plotting functions.
\item \code{Unit}: the unit of the indicator, e.g. USD, thousands, score, etc. Used in some plots if available.
\item \code{Target}: a target for the indicator. Used if normalisation type is distance-to-target.
}

The \code{iMeta} data frame essentially gives details about each of the columns found in \code{iData}, as well as
details about additional data columns eventually created by aggregating indicators. This means that the
entries in \code{iMeta} must include \emph{all} columns in \code{iData}, \emph{except} the three special column names: \code{uCode},
\code{uName}, and \code{Time}. In other words, all column names of \code{iData} should appear in \code{iMeta$iCode}, except
the three special cases mentioned. The \code{iName} column optionally can be used to give longer names to each indicator
which can be used for display in plots.

\code{iMeta} also specifies the structure of the index, by specifying the parent of each indicator and aggregate.
The \code{Parent} column must refer to entries that can be found in \code{iCode}. Try \code{View(ASEM_iMeta)} for an example
of how this works.

\code{Level} is the "vertical" level in the hierarchy, where 1 is the bottom level (indicators), and each successive
level is created by aggregating the level below according to its specified groups.

\code{Direction} is set to 1 if higher values of the indicator should result in higher values of the index, and
-1 in the opposite case.

The \code{Type} column specifies the type of the entry: \code{Indicator} should be used for indicators at level 1.
\code{Aggregate} for aggregates created by aggregating indicators or other aggregates. Otherwise set to \code{Group}
if the variable is not used for building the index but instead is for defining groups of units. Set to
\code{Denominator} if the variable is to be used for scaling (denominating) other indicators. Finally, set to
\code{Other} if the variable should be ignored but passed through. Any other entries here will cause an error.

Note: this function requires the columns above as specified, but extra columns can also be added without
causing errors.
}
\examples{
check_iMeta(ASEM_iMeta)

}
