% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_map_plot_data.R
\name{ch_map_plot_data}
\alias{ch_map_plot_data}
\title{Generate a map for a defined area}
\usage{
ch_map_plot_data(
  map_data,
  locations = NULL,
  lo_pch = 19,
  lo_col = "black",
  lo_bg = "white",
  lo_cex = 0.8,
  lo_text = "Station",
  lo_title = "Location",
  lb_basins = NULL,
  lb_border = "darkred",
  lb_lwd = 2,
  lb_clip = TRUE,
  sb_basins = NULL,
  sb_border = "darkred",
  sb_lwd = 1,
  sb_clip = FALSE,
  trends = NULL,
  tr_pch = c(25, 20, 24),
  tr_col = c("red", "black", "darkblue"),
  tr_cex = c(0.5, 1, 0),
  tr_p = 0.05,
  tr_ltext = c("Significant Increase", "Increase", "No Change", "Decrease",
    "Significant Decrease"),
  tr_lsz = c(1, 0.4, 0.4, 0.4, 1),
  var = NULL,
  vr_pch = 22,
  vr_cex = 2,
  vr_text = NA,
  vr_range = c(0, 1),
  vr_colors = c("darkred", "red", "white", "green", "darkgreen"),
  sc_var = NULL,
  sc_pch = 20,
  sc_range = c(0, 1),
  sc_text = "",
  sc_color = "magenta",
  rivers = TRUE,
  boundaries = TRUE,
  plabels = TRUE,
  pl_cex = 1,
  legend = FALSE,
  le_text = NA,
  x_labels = NULL,
  ...
)
}
\arguments{
\item{map_data}{a list produced by the function ch_get_map_base()}

\item{locations}{a dataframe with longitude, latitude. a third column may contain indexes of symbol types.}

\item{lo_pch}{plotting symbols: default is lo_pch=c(19,19)}

\item{lo_col}{plotting symbol colours: default is lo_col= c("black","black")}

\item{lo_bg}{plotting symbol background (20-24) default is "white"}

\item{lo_cex}{plot symbol size default is 0.8}

\item{lo_text}{legend title text, default is "Station"}

\item{lo_title}{names for different items in legend, default is "Location"

# adding large basin boundaries}

\item{lb_basins}{a list with basin shapefiles}

\item{lb_border}{colour for watershed boundaries: default is "darkred"}

\item{lb_lwd}{width of watershed boundary}

\item{lb_clip}{clip basins at map edge, default is TRUE

# adding WSC basin boundaries}

\item{sb_basins}{a list with basin shapefiles}

\item{sb_border}{colour for watershed boundaries: default is "darkred"}

\item{sb_lwd}{width of watershed boundary}

\item{sb_clip}{clip basins at map edge, default is FALSE

# adding trends}

\item{trends}{a dataframe with four columns (Longitude, Latitude, trend, and pvalue) the trend and pvalue 
are in original units such as slope and probability.  These are converted to indexes (1, 2, 3) decreasing, no trend, 
increasing and (1, 2) not significant and significant}

\item{tr_pch}{plotting symbols: default is tr_pch = c(25, 20, 24)}

\item{tr_col}{plotting symbol colours: default is tr_col = c("red","black","darkblue")}

\item{tr_cex}{plotting symbol size for non-significant and significant:default is tr_cex = c(0.50, 1.0, 0.0}

\item{tr_p}{trend significance level: default is tr_p = 0.05

# adding variable with colour gradient}

\item{tr_ltext}{text for legend}

\item{tr_lsz}{symbol sizes for trends default is c(1,0.40, 0.40, 0.40, 1)}

\item{var}{a dataframe with three columns (Longitude, Latitude, value)}

\item{vr_pch}{a symbol to plot: default is vr_pch = 22}

\item{vr_cex}{size for plot symbol: default is vr_cex = 2.0}

\item{vr_text}{a label to include in the legend}

\item{vr_range}{set ranges for color gradient  default is (0, 1)}

\item{vr_colors}{colours for gradient default is ("darkred", "red","white","green", "darkgreen")

# adding variable with symbol diameter}

\item{sc_var}{a dataframe with three columns (Longitude, Latitude, value)}

\item{sc_pch}{a symbol to plot: default is vr_pch = 20}

\item{sc_range}{set ranges for color gradient default is (0, 1) if not scaled against largest}

\item{sc_text}{a label to include in the legend  default is ""}

\item{sc_color}{symbol colour default is "magenta"

# adding rivers}

\item{rivers}{plot rivers in blue: default is TRUE}

\item{boundaries}{plot provincial boundaries: default is TRUE

# adding provincial boundaries}

\item{plabels}{add the names of provinces: default is TRUE}

\item{pl_cex}{adjusts size of provincial labels: default is 1.0}

\item{legend}{add a legend to the plot: default is FALSE}

\item{le_text}{legend categories: default is NA.}

\item{x_labels}{a dataframe with seven columns (long, lat, pos, cex, font, col, text). Each row provides details for a single label : default is NA}

\item{...}{Other mapping parameters}
}
\value{
Produces a map on an output device.
}
\description{
Generates a map for a defined area. Options to plot station 
 locations, magnitudes, trends etc.  Watershed boundaries and add user 
 defined labels. See article in CWRA "Water News" Spring 2023. 
 The elements are added to the map in an order that puts the symbols on top.
 Large basins, WSC basins, rivers, Provinces, then data symbols.  Labels are 
 added last.
}
\examples{
\donttest{
# Note: example not tested automatically as it is very slow to execute due to the downloading
# get base map
latitude <- c(48.0,  61.0)
longitude <- c(-110.0, -128.5)
mapdir <- tempdir()
# get map data
m_map <- ch_get_map_base(latitude,longitude, 
                     map_proj = "Albers", 
                     map_directory = mapdir, 
                     map_type = "nps")
# add symbols
stations <- HYDAT_list
stations <- stations[,c("Longitude", "Latitude")]
stations <- na.omit(stations)
ch_map_plot_data(m_map, sc_var = stations, sc_text = "Years")
}                    
}
\author{
Paul Whitfield
}
