% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_flow_raster.R
\name{ch_flow_raster}
\alias{ch_flow_raster}
\title{Raster plot of daily streamflows}
\usage{
ch_flow_raster(
  DF,
  rastercolours = c("lightblue", "cyan", "blue", "slateblue", "orange", "red"),
  metadata = NULL
)
}
\arguments{
\item{DF}{A data frame of daily flow data as read by \code{ch_read_ECDE_flows}.}

\item{rastercolours}{A vector of colours used for flow magnitudes (default \code{c("lightblue","cyan", "blue", "slateblue", "orange", "red")}).}

\item{metadata}{A dataframe of station metadata, defaults to \code{HYDAT_list}.}
}
\value{
No value is returned; a standard R graphic is created.
}
\description{
Produces a raster plot: years by day of year, showing magnitude of flow. 
This produces a plot showing the flow data in colours, showing different context than in
a hydrograph. High flows are in warm colours.
}
\examples{
ch_flow_raster(CAN05AA008)

}
\seealso{
\code{\link{ch_read_ECDE_flows}}

\code{\link{ch_flow_raster_trend}} \code{\link{ch_flow_raster_qa}}
}
\author{
Paul Whitfield
}
