% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_QuantileMapping.R
\name{QuantileMapping}
\alias{QuantileMapping}
\title{Quantiles Mapping for seasonal or decadal forecast data}
\usage{
QuantileMapping(
  exp,
  obs,
  exp_cor = NULL,
  sample_dims = "ftime",
  sample_length = NULL,
  method = "QUANT",
  ncores = NULL,
  ...
)
}
\arguments{
\item{exp}{a multi-dimensional array with named dimensions containing the hindcast.}

\item{obs}{a multi-dimensional array with named dimensions (the same as the provided in 'exp') containing the reference dataset.}

\item{exp_cor}{a multi-dimensional array with named dimensions in which the quantile mapping correction will be applied. If it is not specified, the correction is applied in object \code{exp}.}

\item{sample_dims}{a character vector indicating the dimensions that can be used as sample for the same distribution}

\item{sample_length}{a numeric value indicating the length of the timeseries window to be used as sample for the sample distribution and correction. By default, NULL, the total length of the timeseries will be used.}

\item{method}{a character string indicating the method to be used: 'PTF','DIST','RQUANT','QUANT','SSPLIN'. By default, the empirical quantile mapping 'QUANT' is used.}

\item{ncores}{an integer indicating the number of parallel processes to spawn for the use for parallel computation in multiple cores.}

\item{...}{additional arguments passed to the method specified by \code{method}.}
}
\value{
an oject of class \code{s2dv_cube} containing the experimental data after applyingthe quantile mapping correction. 
) <- c(dataset = 1, member = 10, sdate = 20, ftime = 60 ,
}
\description{
This function is a wrapper from fitQmap and doQmap from package 'qmap'to be applied in CSTools objects of class 's2dv_cube'. The quantile mapping adjustment between an experiment, tipically a hindcast, and observations is applied to the experiment itself or to a provided forecast.
}
\details{
The different methods are:
\itemize{ 
\item{'PTF'} {fits a parametric transformations to the quantile-quantile relation of observed and modelled values. See \code{?qmap::fitQmapPTF}.}
\item{'DIST'} {fits a theoretical distribution to observed and to modelled time series. See \code{?qmap::fitQmapDIST}.}
\item{'RQUANT'} {estimates the values of the quantile-quantile relation of observed and modelled time series for regularly spaced quantiles using local linear least square regression. See \code{?qmap::fitQmapRQUANT}.}
\item{'QUANT'} {estimates values of the empirical cumulative distribution function of observed and modelled time series for regularly spaced quantiles. See \code{?qmap::fitQmapQUANT}.}
\item{'SSPLIN'} {fits a smoothing spline to the quantile-quantile plot of observed and modelled time series. See \code{?qmap::fitQmapSSPLIN}.}}
All methods accepts some common arguments:
\itemize{
\item{wet.day} {logical indicating whether to perform wet day correction or not.(Not available in 'DIS' method)}
\item{qstep} {NULL or a numeric value between 0 and 1.}}
}
\seealso{
\code{qmap::fitQmap} and \code{qmap::doQmap}
}
\author{
Nuria Perez-Zanon, \email{nuria.perez@bsc.es}
}
