% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_SplitDim.R
\name{SplitDim}
\alias{SplitDim}
\title{Function to Split Dimension}
\usage{
SplitDim(
  data,
  split_dim = "time",
  indices,
  freq = "monthly",
  new_dim_name = NULL,
  dates = NULL,
  return_indices = FALSE
)
}
\arguments{
\item{data}{An n-dimensional array with named dimensions.}

\item{split_dim}{A character string indicating the name of the dimension to 
split.}

\item{indices}{A vector of numeric indices or dates.}

\item{freq}{A character string indicating the frequency: by 'day', 'month' and 
'year' or 'monthly' (by default). 'month' identifies months between 1 and 12 
independetly of the year they belong to, while 'monthly' differenciates 
months from different years. Parameter 'freq' can also be numeric indicating 
the length in which to subset the dimension.}

\item{new_dim_name}{A character string indicating the name of the new 
dimension.}

\item{dates}{An optional parameter containing an array of dates of class 
'POSIXct' with the corresponding time dimensions of 'data'. It is NULL 
by default.}

\item{return_indices}{A logical value that if it is TRUE, the indices 
used in splitting the dimension will be returned. It is FALSE by default.}
}
\description{
This function split a dimension in two. The user can select the 
dimension to split and provide indices indicating how to split that dimension 
or dates and the frequency expected (monthly or by day, month and year). The 
user can also provide a numeric frequency indicating the length of each division.
}
\examples{
data <- 1 : 20
dim(data) <- c(time = 10, lat = 2)
indices <- c(rep(1,5), rep(2,5))
new_data <- SplitDim(data, indices = indices)
time <- c(seq(ISOdate(1903, 1, 1), ISOdate(1903, 1, 4), "days"),
         seq(ISOdate(1903, 2, 1), ISOdate(1903, 2, 4), "days"),
         seq(ISOdate(1904, 1, 1), ISOdate(1904, 1, 2), "days"))
new_data <- SplitDim(data, indices = time)
new_data <- SplitDim(data, indices = time, freq = 'day')
new_data <- SplitDim(data, indices = time, freq = 'month')
new_data <- SplitDim(data, indices = time, freq = 'year')
}
\author{
Nuria Perez-Zanon, \email{nuria.perez@bsc.es}
}
