% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difficulty_plot.R
\name{difficulty_plot}
\alias{difficulty_plot}
\title{item_difficulty_visualization}
\usage{
difficulty_plot(
  responses,
  title = "Item Difficulty",
  easyFlag = 0.9,
  hardFlag = 0.5
)
}
\arguments{
\item{responses}{A dichotomous item response object (a dataframe or a matrix)}

\item{title}{Title of the plot}

\item{easyFlag}{threshold of the easy item}

\item{hardFlag}{threshold of the hard item}
}
\value{
A data frame sorted by item difficulty in ascending order. A plot of item difficulty in relation to the specified threshold.
}
\description{
plotting results of item difficulty analysis from the Classical test theory framework
}
\examples{

data(dichotomous_response)

# To plot item difficulty with easyFlag of .9 and hardFlag of .5

difficulty_plot(responses = dichotomous_response,
      title = "Item Difficulty Plot", easyFlag = .90, hardFlag = .50)

}
