% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inibestcube.R
\name{inibestcube}
\alias{inibestcube}
\title{Naive estimates for CUBE models without covariates}
\usage{
inibestcube(m,ordinal)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}
}
\value{
A vector \eqn{(\pi, \xi ,\phi)} of parameter estimates of a CUBE model without covariates
}
\description{
Compute \emph{naive} parameter estimates of a CUBE model without covariates for given ordinal responses. 
These preliminary estimators are used within the package code to start the E-M algorithm.
}
\examples{
data(relgoods)
m<-10
ordinal<-na.omit(relgoods[,44])
estim<-inibestcube(m,ordinal)     # Preliminary estimates (pai,csi,phi)
}
\seealso{
\code{\link{inibestcubecov}}, \code{\link{inibestcubecsi}}
}
\keyword{htest}
\keyword{utilities}

