% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{estimate_sigma2}
\alias{estimate_sigma2}
\title{Estimating Noise}
\usage{
estimate_sigma2(Y, X, lambda_hat, y_fixed_hat, alpha_hat, K_hat)
}
\arguments{
\item{Y}{(matrix, n*1) The vector of response variable.}

\item{X}{(matrix, n*d_fix) The fixed effect matrix.}

\item{lambda_hat}{(numeric) The selected tuning parameter based on the
estimated ensemble kernel matrix.}

\item{y_fixed_hat}{(vector of length n) Estimated fixed effect of the
response.}

\item{alpha_hat}{(vector of length n) Kernel effect estimators of the
estimated ensemble kernel matrix.}

\item{K_hat}{(matrix, n*n) Estimated ensemble kernel matrix.}
}
\value{
\item{sigma2_hat}{(numeric) The estimated noise of the fixed
effect.}
}
\description{
An implementation of Gaussian processes for estimating noise.
}
\references{
Jeremiah Zhe Liu and Brent Coull. Robust Hypothesis Test for
Nonlinear Effect with Gaussian Processes. October 2017.s
}
\author{
Wenying Deng
}
\keyword{internal}
