% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{QuadOverLin-class}
\alias{QuadOverLin-class}
\alias{.QuadOverLin}
\alias{QuadOverLin}
\alias{validate_args,QuadOverLin-method}
\alias{to_numeric,QuadOverLin-method}
\alias{size_from_args,QuadOverLin-method}
\alias{sign_from_args,QuadOverLin-method}
\alias{is_atom_convex,QuadOverLin-method}
\alias{is_atom_concave,QuadOverLin-method}
\alias{is_incr,QuadOverLin-method}
\alias{is_decr,QuadOverLin-method}
\alias{is_quadratic,QuadOverLin-method}
\alias{graph_implementation,QuadOverLin-method}
\title{The QuadOverLin class.}
\usage{
QuadOverLin(x, y)

\S4method{validate_args}{QuadOverLin}(object)

\S4method{to_numeric}{QuadOverLin}(object, values)

\S4method{size_from_args}{QuadOverLin}(object)

\S4method{sign_from_args}{QuadOverLin}(object)

\S4method{is_atom_convex}{QuadOverLin}(object)

\S4method{is_atom_concave}{QuadOverLin}(object)

\S4method{is_incr}{QuadOverLin}(object, idx)

\S4method{is_decr}{QuadOverLin}(object, idx)

\S4method{is_quadratic}{QuadOverLin}(object)

\S4method{graph_implementation}{QuadOverLin}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric matrix.}

\item{y}{A scalar \linkS4class{Expression} or numeric constant.}

\item{object}{A \linkS4class{QuadOverLin} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the sum of squared entries in X divided by a scalar y, \eqn{\sum_{i,j} X_{i,j}^2/y}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check the dimensions of the arguments.

\item \code{to_numeric}: The sum of the entries of \code{x} squared over \code{y}.

\item \code{size_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: A logical value indicating whether the atom is weakly increasing.

\item \code{is_decr}: A logical value indicating whether the atom is weakly decreasing.

\item \code{is_quadratic}: True if \code{x} is affine and \code{y} is constant.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric matrix.}

\item{\code{y}}{A scalar \linkS4class{Expression} or numeric constant.}
}}

