% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\docType{class}
\name{Solver-class}
\alias{Solver-class}
\alias{Solver}
\alias{validate_solver,Solver-method}
\alias{nonlin_constr,Solver-method}
\alias{Solver.solve,Solver-method}
\alias{format_results,Solver-method}
\title{The Solver class.}
\usage{
\S4method{validate_solver}{Solver}(solver, constraints)

\S4method{nonlin_constr}{Solver}(solver)

\S4method{Solver.solve}{Solver}(solver, objective, constraints, cached_data,
  warm_start, verbose, ...)

\S4method{format_results}{Solver}(solver, results_dict, data, cached_data)
}
\arguments{
\item{solver}{A \linkS4class{Solver} object.}

\item{constraints}{A list of canonicalized constraints.}

\item{objective}{A list representing the canonicalized objective.}

\item{cached_data}{A list mapping solver name to cached problem data.}

\item{warm_start}{A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{A logical value indicating whether to print solver output.}

\item{...}{Additional arguments to the solver.}

\item{results_dict}{A list containing the solver output.}

\item{data}{A list containing information about the problem.}
}
\description{
This virtual class represents the generic interface for a solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_solver}: Verify the solver can solve the problem.

\item \code{nonlin_constr}: A logical value indicating whether nonlinear constraints are needed.

\item \code{Solver.solve}: Call the solver on the canonicalized problem.

\item \code{format_results}: Convert raw solver output into standard list of results.
}}

