% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_data.R
\name{make_data_single}
\alias{make_data_single}
\title{Generate full dataset}
\usage{
make_data_single(
  model,
  n = 1,
  parameters = NULL,
  param_type = NULL,
  w = NULL,
  P = NULL,
  A = NULL
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{n}{An integer. Number of observations.}

\item{parameters}{A numeric vector. Values of parameters may be specified. By default, parameters is drawn from priors.}

\item{param_type}{A character. String specifying type of parameters to make ("flat", "prior_mean", "posterior_mean", "prior_draw", "posterior_draw", "define). With param_type set to \code{define} use arguments to be passed to \code{make_priors}; otherwise \code{flat} sets equal probabilities on each nodal type in each parameter set; \code{prior_mean}, \code{prior_draw}, \code{posterior_mean}, \code{posterior_draw} take parameters as the means or as draws from the prior or posterior.}

\item{w}{Vector of event probabilities can be provided directly. This is useful for speed for repeated data draws.}

\item{P}{A \code{matrix}. Parameter matrix that can be used to generate w if w is not provided}

\item{A}{A \code{matrix}. Ambiguity matrix that can be used to generate w if w is not provided}
}
\value{
A \code{data.frame} of simulated data.
}
\description{
Generate full dataset
}
\examples{

model <- make_model("X -> Y")

# Simplest behavior uses by default  the parameter vector contained in model,
# which is flat by default:
CausalQueries:::make_data_single(model, n = 5)

CausalQueries:::make_data_single(model, n = 5, param_type = "prior_draw")

# Simulate multiple datasets is fastest if w is provided
w <- get_event_prob(model)
replicate(5, CausalQueries:::make_data_single(model, n = 5, w = w))

}
\keyword{internal}
