fmr.smn.cr <- function(cc, y, x, Abetas = NULL, sigma2 = NULL, pii = NULL, nu=NULL, g = NULL, family = "Normal", error = 0.00001, iter.max = 100)
{
  #Running the algorithm
  out <- algEM.fmr.smn.cr(cc, y, x, Abetas, sigma2, pii, nu, g, family, error, iter.max)

  #show result
  cat('\n')
  cat('-----------------------------------------------------------------\n')
  cat('     Finite Mixture of Regression Models for Censored Data       \n')
  cat('     Based on Scale Mixtures of Normal Distributions             \n')
  cat('-----------------------------------------------------------------\n')
  cat('\n')
  cat('Observations =',length(y))
  cat('\n')
  cat('-----------\n')
  cat('Estimates\n')
  cat('-----------\n')
  cat('\n')
  print(round(out$table,5))
  cat('------------------------\n')
  cat('Model selection criteria\n')
  cat('------------------------\n')
  cat('\n')
  critFin  <- c(out$lk, out$aic, out$bic, out$edc)
  critFin  <- round(t(as.matrix(critFin)),digits=3)
  dimnames(critFin) <- list(c("Value"),c("Loglik", "AIC", "BIC","EDC"))
  print(critFin)
  cat('-------\n')
  cat('Details\n')
  cat('-------\n')
  cat('\n')
  cat("Family =",class(out))
  cat('\n')
  cat('Iterations =',out$iter)
  cat('\n')
  cat("Components =",g)
  cat('\n')
  cat("Convergence =",out$convergence)
  cat('\n')
  cat("Processing time =",out$time,units(out$time))
  cat('\n')
  cat("Level censored =",100*sum(cc==1)/length(y),"%")
  res            <- list(iter = out$iter,criterion = out$criterio, Abetas=out$Abetas, sigma2=out$sigma2, EP=out$EP, table = out$table,loglik=out$lk, AIC=out$aic, BIC=out$bic, EDC=out$edc, time = out$time, convergence = out$convergence)
  obj.out        <- list(res = res)
  class(obj.out) <-  "FMR-SMN-CR"
  return(obj.out)
}

#fit = fmr.smn.cr.R(cc, y, x, Abetas, sigma2, pii, nu=0, g = 2, criteria = TRUE, group = FALSE, family = "Normal", error = 0.00001, iter.max = 100, obs.prob= FALSE)

#initValues1Ng2 <- initial.Values2(cc, as.matrix(y),x,g=2,get.init="MinMax_kmeans",family="NormalC",lower=0.1,upper=0.9,space=0.1,plotLog = TRUE,printNU=TRUE)
#fitN.g2ij1      <- fmr.smn.cr.R( cc, y, x, Abetas = initValues1Ng2$Abetas,  sigma2 = initValues1Ng2$sigma2, pii = initValues1Ng2$pii, nu=initValues1Ng2$nu, g = 2, criteria = TRUE, group = FALSE, family = "NormalC", error = 10^-6, iter.max = 500, obs.prob= FALSE)
