% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfS_StudentT.R
\name{cfS_StudentT}
\alias{cfS_StudentT}
\title{Characteristic function of Student's t-distribution}
\usage{
cfS_StudentT(t, df)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{df}{df degrees of freedom, df > 0}
}
\value{
characteristic function cf(t) of the Student's t-distribution
}
\description{
cfS_StudentT(t, df) evaluates the characteristic function cf(t) of
the Student's t-distribution with the parameters df (degrees of freedom, df > 0)
computed for real vector argument t, i.e.

cfS_StudentT(t,df) = besselK(df/2,abs(t)*sqrt(df),1) * exp(-abs(t)*sqrt(df)) *
                     (sqrt(df)*abs(t))^(df/2) / 2^(df/2-1)/gamma(df/2)
}
\note{
bessel function nefunguje dobre
}
\examples{
## EXAMPLE1 (CF of the Student t-distribution with df = 2)
df <- 2
t <- seq(-5, 5, length.out = 501)
plotGraf(function(t)
  cfS_StudentT(t, df), t, title = "CF of the Student t-distribution with df = 2")

## EXAMPLE2 (PDF/CDF of the Student t-distribution with df = 3)
df <- 2
cf <- function(t)
  cfS_StudentT(t, df)
x <- seq(-8, 8, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, SixSigmaRule = 8)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Student's_t-distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}

Other Symetric Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}
}

