% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{lmvgamma}
\alias{lmvgamma}
\alias{mvgamma}
\title{Multivariate Gamma Function}
\usage{
lmvgamma(x, p)

mvgamma(x, p)
}
\arguments{
\item{x}{non-negative numeric vector, matrix, or array}

\item{p}{positive integer, dimension of a square matrix}
}
\value{
For \code{lmvgamma} log of multivariate gamma of dimension \code{p} for each entry of \code{x}. For non-log variant,
    use \code{mvgamma}.
}
\description{
A special mathematical function related to the gamma function,
    generalized for multivariate gammas. \code{lmvgamma} if the log of the
    multivariate gamma, \code{mvgamma}.

   The multivariate gamma function for a dimension p is defined as:

   \deqn{\Gamma_{p}(a)=\pi^{p(p-1)/4}\prod{j=1}^{p}\Gamma [a+(1-j)/2]}{Gamma_p(a)=\pi^{p(p-1)/4}* Prod_{j=1}^{p}\Gamma[a+(1-j)/2]}
   For \eqn{p = 1}, this is the same as the usual gamma function.
}
\section{Functions}{
\itemize{
\item \code{mvgamma}: Multivariate gamma function.
}}

\examples{
lgamma(1:12)
lmvgamma(1:12,1)
mvgamma(1:12,1)
gamma(1:12)
}
\references{
A. K. Gupta and D. K. Nagar 1999. \emph{Matrix variate distributions}. Chapman and Hall.

Multivariate gamma function.
In \emph{Wikipedia, The Free Encyclopedia},from
\url{https://en.wikipedia.org/w/index.php?title=Multivariate_gamma_function&oldid=808084916}
}
\seealso{
\code{\link{gamma}} and \code{\link{lgamma}}
}
