% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammas.R
\name{mvdigamma}
\alias{mvdigamma}
\title{Multivariate Digamma Function}
\usage{
mvdigamma(x, p)
}
\arguments{
\item{x}{non-negative numeric vector, matrix, or array}

\item{p}{positive integer, dimension of a square matrix}
}
\value{
vector of values of multivariate digamma function.
}
\description{
A special mathematical function related to the gamma function,
    generalized for multivariate distributions.
    The multivariate digamma function is the derivative of the log of the
    multivariate gamma function; for \eqn{p = 1} it is the same as the
    univariate digamma function.

    \deqn{\psi_{p}(a)=\sum _{i=1}^{p}\psi(a+(1-i)/2)}{psi_p(a)=\sum psi(a+(1-i)/2)}
    where \eqn{\psi}{psi} is the univariate digamma function (the
    derivative of the log-gamma function).
}
\examples{
digamma(1:10)
mvdigamma(1:10,1)
}
\references{
A. K. Gupta and D. K. Nagar 1999. \emph{Matrix variate distributions}. Chapman and Hall.

Multivariate gamma function.
In \emph{Wikipedia, The Free Encyclopedia},from
\url{https://en.wikipedia.org/w/index.php?title=Multivariate_gamma_function&oldid=808084916}
}
\seealso{
\code{\link{gamma}}, \code{\link{lgamma}}, \code{\link{digamma}}, and \code{\link{mvgamma}}
}
