% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChronoPhyloMorphospacePlot.R
\name{ChronoPhyloMorphospacePlot}
\alias{ChronoPhyloMorphospacePlot}
\title{Chronophylomorphospace Plot}
\usage{
ChronoPhyloMorphospacePlot(pcoa_data, x_axis = 1, y_axis = 2,
  shadow = TRUE)
}
\arguments{
\item{pcoa_data}{Principal coordinate data in the format output by \link{MorphMatrix2PCoA} that includes a tree and ancestral states.}

\item{x_axis}{Which ordination axis to plot as the x-axis.}

\item{y_axis}{Which ordination axis to plot as the y-axis.}

\item{shadow}{Whether or not to plot a shadow (2D plot) on the bottom face of the 3D plot (defaults to TRUE).}
}
\description{
Plots a 3D chronophylomorphospace.
}
\details{
Creates a movable three-dimensional (two ordination axes plus time) plot of a phylomorphospace.

Intended to mimic the data visualisation of Sakamoto and Ruta (2012; their Video S1).
}
\examples{
\donttest{

# Set random seed:
set.seed(4)

# Generate a random tree for the Michaux 1989 data set:
Tree <- rtree(nrow(Michaux1989$Matrix_1$Matrix))

# Set root time so latest tip terminates at the present:
Tree$root.time <- max(diag(vcv(Tree)))

# Add taxon names to the tree:
Tree$tip.label <- rownames(Michaux1989$Matrix_1$Matrix)

# Perform a phylogenetic Principal Coordinates Analysis:
pcoa_data <- MorphMatrix2PCoA(Michaux1989, Tree = Tree)

# Plot a chronophylomorphospace:
ChronoPhyloMorphospacePlot(pcoa_data)

}
}
\references{
Sakamoto, M. and Ruta, M. 2012. Convergence and divergence in the evolution of cat skulls: temporal and spatial patterns of morphological diversity. PLoS ONE, 7, e39752.
}
\author{
Emma Sherratt \email{emma.sherratt@gmail.com} and Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
\keyword{coordinates}
\keyword{principal}
