% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{cn}
\alias{cn}
\title{Percentage of cold nights}
\usage{
cn(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{minimum temperature}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
percentage of cold nights
}
\description{
Percentages of days with TN lower than the 10th percentile.
}
\section{Formula}{
 \deqn{cn = \frac{No. days TN <  10p} {No. days} * 100}
}

\examples{
data(data_all)
cn(data=data_all$tn)
}
