% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize.R
\name{randomize}
\alias{randomize}
\alias{randomise}
\title{Set an experimental incomplete block design}
\usage{
randomize(
  npackages,
  itemnames,
  ncomp = 3,
  availability = NULL,
  props = NULL,
  ...
)
}
\arguments{
\item{npackages}{an integer for the number of incomplete blocks to be generated}

\item{itemnames}{a character for the name of items tested in the experiment}

\item{ncomp}{an integer for the number of items to be assigned to each incomplete block}

\item{availability}{optional, a vector with integers indicating the 
number of plots available for each \var{itemnames}}

\item{props}{optional, a numeric vector with the desired proportions
for each \var{itemnames}}

\item{...}{additional arguments passed to methods}
}
\value{
A dataframe with the randomized design
}
\description{
Generate an incomplete block A-optional design. The function is optimized for 
incomplete blocks of three, but it will also work with comparisons of any 
other number of options. 
The design strives for approximate A optimality, this means that it is robust 
to missing observations. It also strives for balance for positions of each option.
Options are equally divided between first, second, third, etc. position. 
The strategy is to create a "pool" of combinations that does not repeat 
combinations and is A-optimal. Then this pool is ordered to make subsets of 
consecutive combinations also relatively balanced and A-optimal
}
\examples{
ncomp = 3
npackages = 20
itemnames = c("apple","banana","grape","mango", "orange")
availability = c(5, 8, 50, 50, 50)

randomize(ncomp = ncomp,
          npackages = npackages,
          itemnames = itemnames)

randomize(ncomp = ncomp,
          npackages = npackages,
          itemnames = itemnames,
          availability = availability)

\dontshow{if (interactive()           ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# run diagnostics to certify that randomization is balanced
# the number of interactions should have the lower sd as possible
# this verification may not work well when technologies are 
# tested in different proportions
design = randomize(ncomp = ncomp,
                   npackages = npackages,
                   itemnames = itemnames)

design$best = "A"

design$worst = "C"

# number of times each item is tested in the 
# trial design
ntest = table(unlist(design[,c(1:3)]))

ntest

# put into the PlackettLuce structure to check 
# number of interactions between items 
r = gosset::rank_tricot(design, c(1:3), c(4:5))

bn = gosset::set_binomialfreq(r)

bn$interactions = bn$win1 + bn$win2

bn = bn[,c(1,2,5)]

bn
\dontshow{\}) # examplesIf}
}
\references{
Bailey and Cameron (2004). Combinations of optimal designs. 
  \url{https://webspace.maths.qmul.ac.uk/l.h.soicher/designtheory.org/library/preprints/optimal.pdf}
}
\author{
Jacob van Etten
}
