
;;; Tutorial example on using CoCo-graphs
;;; =====================================

; Create a CoCo-object:

(def hustage-object (make-coco))

(send hustage-object :set-data-file "../../Datasets/roofs.dat")
(send hustage-object :read-specification)
(send hustage-object :set-read 'subset "pAkhieybaugn1234567890rf")
(send hustage-object :read-observations)
(send hustage-object :exclude-missing 'on)

(def model-1 (send hustage-object :make-model "*"))

(def model-2 (send hustage-object :make-model "."))

(def model-3 (send hustage-object :make-model "[[pybag][ybaug][ybun2][n12][bn8][n478][34578][h348][4589][Aey][Aie][kie][69][30][nr][bf]]"))

(def graph-3 (send model-3 :make-graph :title "Hustage"))

;(send graph-3 :vertex-label #\N "N: Nummer" :redraw nil)
(send graph-3 :vertex-label #\p "p: Postnummer" :redraw nil)
(send graph-3 :vertex-label #\A "A: Ejeres alder" :redraw nil)
(send graph-3 :vertex-label #\k "k: Koen" :redraw nil)
(send graph-3 :vertex-label #\h "h: Husejer" :redraw nil)
(send graph-3 :vertex-label #\i "i: Indkomst (hustand)" :redraw nil)
(send graph-3 :vertex-label #\e "e: Erhverv" :redraw nil)
(send graph-3 :vertex-label #\y "y: Byggeaar" :redraw nil)
(send graph-3 :vertex-label #\b "b: Belaegning (nuvaerende)" :redraw nil)
(send graph-3 :vertex-label #\a "a: Alder (belaegning)" :redraw nil)
(send graph-3 :vertex-label #\u "u: Udskiftning (paataenkt)" :redraw nil)
(send graph-3 :vertex-label #\g "g: Grund (udskiftning)" :redraw nil)
(send graph-3 :vertex-label #\n "n: Ny belaegning" :redraw nil)
;(send graph-3 :vertex-label #\X "X: " :redraw nil)
;(send graph-3 :vertex-label #\Y "Y: " :redraw nil)
;(send graph-3 :vertex-label #\Z "Z: " :redraw nil)
(send graph-3 :vertex-label #\1 "1: Billig" :redraw nil)
(send graph-3 :vertex-label #\2 "2: Taet" :redraw nil)
(send graph-3 :vertex-label #\3 "3: Robust" :redraw nil)
(send graph-3 :vertex-label #\4 "4: Paent" :redraw nil)
(send graph-3 :vertex-label #\5 "5: Levetid" :redraw nil)
(send graph-3 :vertex-label #\6 "6: Vedligeholdelse" :redraw nil)
(send graph-3 :vertex-label #\7 "7: Kvalitet" :redraw nil)
(send graph-3 :vertex-label #\8 "8: Udseende" :redraw nil)
(send graph-3 :vertex-label #\9 "9: Ved ikke" :redraw nil)
(send graph-3 :vertex-label #\0 "0: Andet" :redraw nil)
(send graph-3 :vertex-label #\r "r: Raadgivning" :redraw nil)
(send graph-3 :vertex-label #\f "f: Asbestfri" :redraw nil)

(send graph-3 :vertex-position #\p '(-20 40 0))
(send graph-3 :vertex-position #\A '(20 20 0))
(send graph-3 :vertex-position #\k '(40 40 0))
(send graph-3 :vertex-position #\h '(20 -20 0))
(send graph-3 :vertex-position #\i '(40 20 0))
(send graph-3 :vertex-position #\e '(20 40 0))
(send graph-3 :vertex-position #\y '(10 30 0))
(send graph-3 :vertex-position #\b '(30 0 0))
(send graph-3 :vertex-position #\a '(-20 20 0))
(send graph-3 :vertex-position #\u '(-40 20 0))
(send graph-3 :vertex-position #\g '(-40 40 0))
(send graph-3 :vertex-position #\n '(-30 0 0))
(send graph-3 :vertex-position #\1 '(0 5 0))
(send graph-3 :vertex-position #\2 '(0 10 0))
(send graph-3 :vertex-position #\3 '(30 -40 0))
(send graph-3 :vertex-position #\4 '(-30 -10 0))
(send graph-3 :vertex-position #\5 '(-30 -40 0))
(send graph-3 :vertex-position #\6 '(-40 -20 0))
(send graph-3 :vertex-position #\7 '(0 -20 0))
(send graph-3 :vertex-position #\8 '(30 -10 0))
(send graph-3 :vertex-position #\9 '(-20 -20 0))
(send graph-3 :vertex-position #\0 '(40 -40 0))
(send graph-3 :vertex-position #\r '(-40 0 0))
(send graph-3 :vertex-position #\f '(40 0 0))

(send graph-3 :vertex-label-position #\6 '(-5 -5 0))
(send graph-3 :vertex-label-position #\3 '(-5 -5 0))
(send graph-3 :vertex-label-position #\0 '(-5  5 0))
(send graph-3 :vertex-label-position #\r '(-5 -5 0))
(send graph-3 :vertex-label-position #\u '(-5 -5 0))
(send graph-3 :vertex-label-position #\b '(-20 -5 0))
(send graph-3 :vertex-label-position #\i '(-5 -5 0))
(send graph-3 :vertex-label-position #\k '(-5 -5 0))
(send graph-3 :vertex-label-position #\g '(-5 -10 0))
(send graph-3 :vertex-label-position #\A '(-5 5 0))
(send graph-3 :vertex-label-position #\i '(-10 -5 0))
(send graph-3 :vertex-label-position #\f '(-10 5 0))
(send graph-3 :vertex-label-position #\b '(-30 -5 0))
(send graph-3 :vertex-label-position #\8 '(-5 -5 0))

(send graph-3 :item-color 'vertex-label 'red)

(send graph-3 :vertex-label-arrow #\6 T)
(send graph-3 :vertex-label-arrow #\3 T)
(send graph-3 :vertex-label-arrow #\0 T)
(send graph-3 :vertex-label-arrow #\r T)
(send graph-3 :vertex-label-arrow #\u T)
(send graph-3 :vertex-label-arrow #\b T)
(send graph-3 :vertex-label-arrow #\i T)
(send graph-3 :vertex-label-arrow #\k T)
(send graph-3 :vertex-label-arrow #\g T)
(send graph-3 :vertex-label-arrow #\A T)
(send graph-3 :vertex-label-arrow #\i T)
(send graph-3 :vertex-label-arrow #\f T)
(send graph-3 :vertex-label-arrow #\b T)
(send graph-3 :vertex-label-arrow #\8 T)

(send graph-3 :size 550 700)

(send graph-3 :vertex-position #\a '(-20 40 0) )
(send graph-3 :vertex-position #\p '(-40 40 0) )
(send graph-3 :vertex-position #\u '(-10 5 0)  )
(send graph-3 :vertex-position #\g '(-20 20 0) )
(send graph-3 :vertex-position #\1 '(-40 10 0) )
(send graph-3 :vertex-position #\2 '(-40 20 0) )
(send graph-3 :vertex-position #\y '(0 30 0)   )

(send graph-3 :vertex-label-position #\u '(-10 5 0))
(send graph-3 :vertex-label-position #\g '(0 -5 0))
