% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalAR.R
\name{seasonalAR}
\alias{seasonalAR}
\title{Seasonal AR model}
\usage{
seasonalAR(x, ACS, season = "month")
}
\arguments{
\item{x}{vector of dates for gaussian process generation}

\item{ACS}{list of ACS for each season}

\item{season}{season name}
}
\description{
Seasonal AR model
}
\examples{

data('precip')

\dontshow{
 precip <- precip[between(date, as.POSIXct('1990-1-01', format('\%Y-\%m-\%d'), tz = 'America/Regina'),
 as.POSIXct('1990-1-10', format('\%Y-\%m-\%d'), tz = 'America/Regina'))]
}
x <- seasonalACF(precip, 'month')

seasonalAR(precip$date, x)

}
\keyword{internal}
