% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs.R
\name{acs}
\alias{acs}
\title{AutoCorrelation Structure}
\usage{
acs(id, ...)
}
\arguments{
\item{id}{autocorrelation structure id}

\item{...}{other arguments (t as lag and acs parameters)}
}
\description{
Provides a parametric function that describes the values of the linear autocorrelation up to desired lags. For more details on the parametric autocorrelation structures see section 3.2 in Papalexiou (2018).
}
\examples{

library(CoSMoS)

## specify lag
t <- 0:10

## get the ACS
f <- acs('fgn', t = t, H = .75)
b <- acs('burrXII', t = t, scale = 1, shape1 = .6, shape2 = .4)
w <- acs('weibull', t = t, scale = 2, shape = 0.8)
p <- acs('paretoII', t = t, scale = 3, shape = 0.3)

## visualize the ACS
dta <- data.table(t, f, b, w, p)

m.dta <- melt(dta, id.vars = 't')

ggplot(m.dta,
       aes(x = t,
           y = value,
           group = variable,
           colour = variable)) +
  geom_point(size = 2.5) +
  geom_line(lwd = 1) +
  scale_color_manual(values = c('steelblue4', 'red4', 'green4', 'darkorange'),
                     labels = c('FGN', 'Burr XII', 'Weibull', 'Pareto II'),
                     name = '') +
  labs(x = bquote(lag ~ tau),
       y = 'Acf') +
  scale_x_continuous(breaks = t) +
  theme_classic()

}
\references{
Papalexiou, S.M. (2018). Unified theory for stochastic modelling of hydroclimatic
processes: Preserving marginal distributions, correlation structures,
and intermittency. Advances in Water Resources, 115, 234-252, \doi{10.1016/j.advwatres.2018.02.013}
}
