% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anisotropyT.R
\name{anisotropyT}
\alias{anisotropyT}
\title{Anisotropy transformation}
\usage{
anisotropyT(id, ...)
}
\arguments{
\item{id}{anisotropy type id (\code{affine}, \code{swirl}, and \code{wave})}

\item{...}{additional arguments (vector of coordinates and parameters of the anisotropy transformations)}
}
\description{
Provides parametric functions that describe different types of planar deformation fields, including affine (rotation and stretching), and swirl-like deformation. For more details see Papalexiou et al.(2021) and references therein.
}
\examples{

library(CoSMoS)

## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

## get the anisotropy field
at1 <- anisotropyT('affine',
                 spacepoints = coord,
                 phi1 = 0.5,
                 phi2 = 2,
                 phi12 = 0,
                 theta = -pi/3)
at2 <- anisotropyT('swirl',
                 spacepoints = coord,
                 x0 = floor(m / 2),
                 y0 = floor(m / 2),
                 b = 10,
                 alpha = 1.5 * pi)
at3 <- anisotropyT('wave',
                 spacepoints = coord,
                 phi1 = 0.5,
                 phi2 = 2,
                 beta = 3,
                 theta = 0)

## visualize anisotropy field
aux = data.frame(lon = at2[ ,1], lat = at2[ ,2], id1 = rep(1:m, each = m), id2 = rep(1:m, m))
ggplot(aux, aes(x = lon, y = lat)) +
geom_path(aes(group = id1)) +
geom_path(aes(group = id2)) +
geom_point(col = 2) +
theme_light()

}
\references{
Papalexiou, S. M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond,
Water Resources Research, \doi{10.1029/2020WR029466}
}
