% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortTiming.R
\name{plotCohortTiming}
\alias{plotCohortTiming}
\title{Plot summariseCohortTiming results.}
\usage{
plotCohortTiming(
  result,
  plotType = "boxplot",
  timeScale = "days",
  uniqueCombinations = TRUE,
  facet = c("cdm_name", "cohort_name_reference"),
  colour = c("cohort_name_comparator")
)
}
\arguments{
\item{result}{A summarised_result object. Output of summariseCohortTiming().}

\item{plotType}{Type of desired formatted table, possibilities are "boxplot" and
"density".}

\item{timeScale}{Time scale to plot results. Can be days or years.}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{facet}{Columns to facet by. See options with \code{tidyColumns(result)}.
Formula is also allowed to specify rows and columns.}

\item{colour}{Columns to color by. See options with \code{tidyColumns(result)}.}
}
\value{
A ggplot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(duckdb)
library(CDMConnector)
library(DrugUtilisation)

con <- dbConnect(duckdb(), eunomiaDir())
cdm <- cdmFromCon(con, cdmSchem = "main", writeSchema = "main")

cdm <- generateIngredientCohortSet(
  cdm = cdm,
  name = "my_cohort",
  ingredient = c("acetaminophen", "morphine", "warfarin")
)

timings <- summariseCohortTiming(cdm$my_cohort)

plotCohortTiming(
  timings,
  timeScale = "years",
  facet = c("cdm_name", "cohort_name_reference"),
  colour = c("cohort_name_comparator")
)

cdmDisconnect(cdm)
}

}
