% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortTiming.R
\name{tableCohortTiming}
\alias{tableCohortTiming}
\title{Format a summariseCohortTiming result into a visual table.}
\usage{
tableCohortTiming(
  result,
  timeScale = "days",
  uniqueCombinations = TRUE,
  type = "gt",
  header = strataColumns(result),
  groupColumn = c("cdm_name"),
  hide = c("variable_level", settingsColumns(result)),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{timeScale}{Time scale to show, it can be "days" or "years".}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}
}
\value{
A formatted table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(omock)
library(DrugUtilisation)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm <- generateIngredientCohortSet(
  cdm = cdm,
  name = "my_cohort",
  ingredient = c("acetaminophen", "morphine", "warfarin")
)

timings <- summariseCohortTiming(cdm$my_cohort)

tableCohortTiming(timings, timeScale = "years")

cdmDisconnect(cdm)
}

}
