% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireIsEntry.R
\name{requireIsFirstEntry}
\alias{requireIsFirstEntry}
\title{Restrict cohort to first entry}
\usage{
requireIsFirstEntry(
  cohort,
  cohortId = NULL,
  name = tableName(cohort),
  .softValidation = TRUE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
A cohort table in a cdm reference.
}
\description{
\code{requireIsFirstEntry()} filters cohort records, keeping only the first
cohort entry per person.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 <- requireIsFirstEntry(cdm$cohort1)
}

}
