% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankTS.R
\name{RankTS}
\alias{RankTS}
\title{Rank the time series (ARMA) models based on the confidence envelope for minimum ZIC}
\usage{
RankTS(x,max.p,max.q,alphaval=0.95,model_ZIC="AIC")
}
\arguments{
\item{x}{a vector of time series data (should be included with the maximum of 1000 data points).}

\item{max.p}{maximum value for AR coefficient.}

\item{max.q}{maximum value for MA coefficient.}

\item{alphaval}{confidence limit \eqn{(1-\alpha)} (Default is 0.95).}

\item{model_ZIC}{type of the information criterion, it can be "AIC", "BIC", or "AICc" (Default is the "AIC").}
}
\value{
a list of ranked models which lies in the confidence envelope, \eqn{CE(\alpha).}
\item{Ranked_Models}{A set of top ranked time series models which lie in the confidence envelope \eqn{CE(\alpha)} (with AR and MA coefficients, ZIC values ("AIC", "BIC", or "AICc")).}

\item{Confidence_Envelope}{gives the confidence envelope \eqn{CE(\alpha)} for the minimum ZIC.}

\item{Confidence_Limit}{the confidence limit, \eqn{1-\alpha}.}

\item{Total_Models}{number of total fitted models.}
}
\description{
Narrow down the number of models to look at in model selection using the confidence envelope based on the minimum ZIC values for time series data. Here, we compute the ZIC values ("AIC", "BIC", or "AICc") for time-series data, confidence envelope for the minimum ZIC values for the given confidence limit, and rank the top models which lie in the confidence envelope.
}
\details{
This program involves the computation of multivariate normal-probabilities with covariance matrices based on minimum ZIC inverting the CDF of the minimum ZIC. It involves both the computation of singular and non-singular probabilities. The methodology is described in Genz (1992).

Let \eqn{X_j} be the ZIC value for the \eqn{j^{th}} fitted model. Compute the cdf values of the minimum ZIC, \eqn{F_{X_{(1)}}(\cdot)} numerically and then obtain the \eqn{100\cdot (1-\alpha)\%} confidence envelope:
\deqn{CE(\alpha)=F^{-1}_{X_{(1)}}(1-\alpha)}

See details:

Jayaweera I.M.L.N, Trindade A.A., ``How Certain are You in Your Minimum AIC and BIC Values?", Sankhya A (2023+)
}
\examples{
\donttest{
library("ConfZIC")
data(Sunspots)
x=Sunspots
RankTS(x,max.p=13,max.q=13,0.95,"AICc")
}
}
\references{
Genz, A. (1992). Numerical computation of multivariate normal probabilities. Journal of computational and graphical statistics, 1(2), 141-149.
}
