# CongreveLamsdell2016

This R package provides data and analyses that accompany the paper

- Smith, M. R. (2019), Bayesian and parsimony approaches reconstruct informative trees from simulated morphological datasets, _Biological Letters_, 15:20180632, 
doi:[10.1098/rsbl.2018.0632](https://doi.org/10.1098/rsbl.2018.0632).

It incorporates data from:

- Congreve, C. R., and J. C. Lamsdell. 2016. Implied weighting and its utility in palaeontological datasets: a study using modelled phylogenetic matrices. _Palaeontology_, 59:447–462. doi:[10.1111/pala.12236](https://dx.doi.org/10.1111/pala.12236).

- Congreve, C. R., and J. C. Lamsdell. 2016. Data from: Implied weighting and its utility in palaeontological datasets: a study using modelled phylogenetic matrices. _Dryad Digital Repository_, doi:[10.5061/dryad.7dq0j](https://dx.doi.org/10.5061/dryad.7dq0j).

Some of these data are used in the [`Quartet`](https://ms609.github.io/Quartet) package.

Equivalent data and analyses from data simulated by O'Reilly _et al._ (2016) 
are available at [ms609.github.io/OReillyEtAl2016](https://ms609.github.io/OReillyEtAl2016).

## Installation 

Install the package in `R` with:
`devtools::install_github('ms609/CongreveLamsdell2016')`.


## Documentation

The package includes documentation and visualizations of its results:

* R Package manual: [PDF](https://ms609.github.io/CongreveLamsdell2016/CongreveLamsdell2016_1.0.0.pdf)

* How to conduct the analyses:
[HTML](https://ms609.github.io/CongreveLamsdell2016/Conduct-analyses.html) | 
[PDF](https://ms609.github.io/CongreveLamsdell2016/Conduct-analyses.pdf)

* Node support comparisons:
[HTML](https://ms609.github.io/CongreveLamsdell2016/Compare-node-supports.html) | 
[PDF](https://ms609.github.io/CongreveLamsdell2016/Compare-node-supports.pdf)

* Comparisons of phylogenetic methods:
[HTML](https://ms609.github.io/CongreveLamsdell2016/Compare-methods.html) | 
[PDF](https://ms609.github.io/CongreveLamsdell2016/Compare-methods.pdf)
