% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_paths.R
\name{transition_paths}
\alias{transition_paths}
\title{Extract transition paths from a \code{convergence.clubs} object}
\usage{
transition_paths(
  clubs,
  include_unit_names = TRUE,
  output_type = c("list", "data.frame")
)
}
\arguments{
\item{clubs}{an object of class \code{convergence.clubs} (created by either function
\code{findClubs} or \code{\link{mergeClubs}}).}

\item{include_unit_names}{logical, if TRUE (the default) adds a column with unit names (only
if present in the \code{convergence.clubs} object passed to \code{clubs}).}

\item{output_type}{string indicating if the function should output a list or a data frame.
Possible options are "list" and "data.frame", default is "list".}
}
\value{
If \code{output_type=="list"}, a list of data frames, one for each club;
each data frame will contain transition paths for the units in the correspondent club.
If \code{output_type=="data.frame"}, a data.frame.
}
\description{
Given a \code{convergence.clubs} object (created by either \code{findClubs}
or \code{mergeClubs} function), returns a list with transition paths for each
club.
}
\examples{
data("filteredGDP")

# Cluster Countries using GDP from year 1970 to year 2003
clubs <- findClubs(filteredGDP, dataCols=2:35, unit_names = 1, refCol=35,
                   time_trim = 1/3, cstar = 0, HACmethod = "FQSB")

# Extract Transition Paths
tp <- transition_paths(clubs)
tp <- transition_paths(clubs, output_type = 'data.frame')





}
\references{
Phillips, P. C.; Sul, D., 2007. Transition modeling and econometric convergence tests. Econometrica 75 (6), 1771-1855.

Phillips, P. C.; Sul, D., 2009. Economic transition and growth. Journal of Applied Econometrics 24 (7), 1153-1185.
}
\seealso{
\code{\link{findClubs}}, Finds Convergence Clubs;
\code{\link{mergeClubs}}, Merges a list of clubs created by \code{findClubs};
\code{\link{plot.convergence.clubs}}, Plots transition paths from a \code{convergence.clubs} object.
}
