% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_tweets_json}
\alias{load_tweets_json}
\title{load_tweets_json}
\usage{
load_tweets_json(data_dir, query = NULL, query_error_ok = TRUE)
}
\arguments{
\item{data_dir}{string that leads to the directory containing JSON files}

\item{query}{(string) JSON Pointer query passed on to
\link[RcppSimdJson]{fload} (optional). Default: \code{NULL}}

\item{query_error_ok}{(Boolean) stop if \code{query} causes an error. Passed on
to \link[RcppSimdJson]{fload} (optional). Default: \code{FALSE}}
}
\value{
a data.table with all tweets loaded
}
\description{
Very efficient and fast way to load tweets stored in JSON files.
Wrapper of the function \link[RcppSimdJson]{fload}
}
\details{
This function is optimized to load tweets that were
collected using the academicTwittr Package (Twitter API V2).
It uses RcppSimdJson to load the JSON files, which is extremely
fast and efficient. It returns the twitter data as is. The only changes
are that the function renames the \code{id} of tweets to \code{tweet_id}, and
it also deduplicates the data (by \code{tweet_id}).
The function expects that the individual JSON files start with \code{data}.
}
