% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRsurv.R
\name{IRsurv}
\alias{IRsurv}
\title{An information ratio-based goodness-of-fit test for copula models on censored data}
\source{
Tao Sun, Yu Cheng, Ying Ding (2022). An information Ratio-based
Goodness-of-Fit Test for Copula Models on Censored Data. Biometrics (Accepted).
}
\usage{
IRsurv(
  data,
  censoring = "rc",
  copula = "clayton",
  fams = c(3, 3, 3),
  R = 200,
  parallel = "no",
  ncpus = 1
)
}
\arguments{
\item{data}{the input data; see examples for details.}

\item{censoring}{types of censoring, including "rc", "ic", "rec_bivariate", "rec_multivariate".}

\item{copula}{specify the copula family to be tested; default is "clayton"; others include "copula2", "gumbel", "frank", "gaussian", and "d-vine". "d-vine" is only for censoring = "rec_multivariate".}

\item{fams}{specify the unconditional copulas by following the style of the VineCopula package when copula = "d-vine". Only d = 4 is supported at this stage. The conditional copulas are set as "frank" by default.}

\item{R}{number of Bootstraps; default is 200.}

\item{parallel}{indicator of parallel computing; can be "no" or "multicore"; default is "no".}

\item{ncpus}{number of cpus to be assigned for parallel computing; default is 1.}
}
\value{
the p value of the IR test
}
\description{
Fits an Information ratio (IR)-based goodness-of-fit test for copula models under various censoring types.
}
\examples{
\dontrun{
# Goodness of fit under right censoring
data("data_sim_RC")
test_rc <- IRsurv(data = data_sim_RC, censoring = "rc", copula = "clayton", R = 200)
test_rc
# Goodness of fit under interval censoring
data("data_sim_ic")
test_ic <- IRsurv(data = data_sim_ic, censoring = "ic", copula = "clayton", R = 200)
test_ic
# Goodness of fit under bivariate recurrent events
data("data_sim_rec")
test_rec_bi <- IRsurv(data = data_sim_rec, censoring = "rec_bivariate",
                      copula = "clayton", R = 200)
test_rec_bi
# Goodness of fit of D-vine copula under multivariate recurrent events
data("data_sim_multi_rec")
test_rec_mv <- IRsurv(data = data_sim_multi_rec, censoring = "rec_multivariate",
                      fams = c(3,3,3), R = 200)
test_rec_mv
}
}
