% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstDiscrete.R
\name{EstDiscrete}
\alias{EstDiscrete}
\title{Copula-based estimation of mixed regression models for discrete response}
\usage{
EstDiscrete(
  y,
  disc,
  family,
  rot = 0,
  clu,
  xc = NULL,
  xm = NULL,
  start,
  LB,
  UB,
  nq = 25,
  dfC = NULL,
  offset = NULL,
  adj = 1,
  prediction = TRUE
)
}
\arguments{
\item{y}{n x 1 vector of response variable (assumed continuous).}

\item{disc}{function for margins: 1 (Bernoulli), 2 (Poisson), 3 (Negative Binomial), 4 (Geometric).}

\item{family}{copula family: "gaussian" , "t" , "clayton" ,  "frank" , "fgm", gumbel".}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{clu}{variable of size n defining the clusters; can be a factor}

\item{xc}{covariates of size n for the estimation of the copula, in addition to the constant; default is NULL.}

\item{xm}{covariates of size n for the estimation of the mean of the margin, in addition to the constant; default is NULL.}

\item{start}{starting point for the estimation; could be the ones associated with a Gaussian-copula model defined by lmer.}

\item{LB}{lower bound for the parameters.}

\item{UB}{upper bound for the parameters.}

\item{nq}{number of nodes and weighted for Gaussian quadrature of the product of conditional copulas; default is 25.}

\item{dfC}{degrees of freedom for a Student margin; default is 0.}

\item{offset}{offset (default is NULL)}

\item{adj}{tuning parameter (>= 1) that can be used to prevent overflow when the cluster size n is very large; when  n<=100 OR Bernoulli marginals, no adjustment is required; when n>=500 for the Poisson likelihood fails due to overflow problem;  adj=3 prevents this in 100\% cases}

\item{prediction}{logical variable for prediction of latent variables V (default is TRUE).}
}
\value{
\item{coefficients}{Estimated parameters}

\item{sd}{Standard deviations of the estimated parameters}

\item{tstat}{T statistics for the estimated parameters}

\item{pval}{P-values of the t statistics for the estimated parameters}

\item{gradient}{Gradient of the log-likelihood}

\item{loglik}{Log-likelihood}

\item{aic}{AIC coefficient}

\item{bic}{BIC coefficient}

\item{cov}{Covariance matrix of the estimations}

\item{grd}{Gradients by clusters}

\item{clu}{Cluster values}

\item{Matxc}{Matrix of covariates defining the copula parameters, including a constant}

\item{Matxm}{Matrix of covariates defining the margin parameters, including a constant}

\item{V}{Estimated value of the latent variable by clusters (if prediction=TRUE)}

\item{cluster}{Unique clusters}

\item{family}{Copula family}

\item{thC0}{Estimated parameters of the copula by observation}

\item{thF}{Estimated parameters of the margins by observation}

\item{disc}{Discrete margin number}

\item{rot}{rotation}

\item{dfC}{Degrees of freedom for the Student copula}
}
\description{
This function computes the estimation of a copula-based  2-level hierarchical model.
}
\examples{
data(poisson) #simulated data with poisson margins
start=c(0,0,0); LB=rep(-10,3);UB=rep(10,3)
y=poisson$y; clu=poisson$clu;xm=poisson$xm
EstDiscrete(y,disc=2,family="clayton",rot=90,clu=clu,xm=xm,start=start,LB=LB,UB=UB)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii, Bouchra R. Nasri and Bruno N. Remillard
}
