% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{count_table}
\alias{count_table}
\title{Summary of a count variable}
\usage{
count_table(count, breaks, formatChar = FALSE)
}
\arguments{
\item{count}{integer, observed count value for every individual in the
sample.}

\item{breaks}{integer, values at which the breaks should happen. The function
will compute the observed frequency in \code{[breaks[i], breaks[i + 1])}.}

\item{formatChar}{logical, should the values be converted to character and
formatted?}
}
\value{
\code{matrix} with 2 rows and \code{length(breaks)} columns.  The
    column names are the cells names. The rows are the observed frequencies
    and relative frequencies (probabilities).
}
\description{
Summary of a count variable.
}
\details{
The function does a similar job to \code{table()} with more flexibility
introduced by the argument \code{breaks}. The user can decide how to break
the count values and decide to merge some cells if needed.
}
