% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_proportionalHazard}
\alias{plot_proportionalHazard}
\title{plot_proportionalHazard}
\usage{
plot_proportionalHazard(model)
}
\arguments{
\item{model}{Coxmos model.}
}
\value{
A \code{ggplot2} object visualizing the assessment of the proportional hazards assumption
for the given Coxmos model. The plot displays the Schoenfeld residuals against time for each
variable or factor level from the model. A line is fitted to these residuals to indicate any trend,
which can suggest a violation of the proportional hazards assumption.
}
\description{
Generates a visual assessment of the proportional hazards assumption for a given Coxmos model.
The function integrates the capabilities of the \code{survival::cox.zph} and \code{survminer::ggcoxzph}
functions to produce a \code{ggplot2} graph that visualizes the validity of the proportional hazards
assumption.
}
\details{
The proportional hazards assumption is a fundamental tenet of the Cox proportional hazards
regression model. It posits that the hazard ratios between groups remain constant over time.
Violations of this assumption can lead to biased or misleading results. Thus, assessing the validity
of this assumption is crucial in survival analysis.

The function begins by validating the provided model to ensure it belongs to the Coxmos class. If
the model is valid, the function then evaluates the proportional hazards assumption using the
\code{survival::cox.zph} function. The results of this evaluation are then visualized using the
\code{survminer::ggcoxzph} function, producing a \code{ggplot2} graph.

The resulting plot provides a visual representation of the Schoenfeld residuals against time,
allowing for an intuitive assessment of the proportional hazards assumption. Each variable or
factor level from the model is represented in the plot, and the global test for the proportional
hazards assumption is also provided.

This function is instrumental in ensuring the robustness and validity of survival analysis results,
offering a comprehensive visualization that aids in the interpretation and validation of the Coxmos
model's assumptions.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
splsicox.model <- splsicox(X, Y, n.comp = 2, penalty = 0.5, x.center = TRUE, x.scale = TRUE)
plot_proportionalHazard(splsicox.model)
}
\references{
\insertRef{survival_package}{Coxmos}
\insertRef{survminer_package}{Coxmos}
\insertRef{Grambsch_1994}{Coxmos}
\insertRef{Schoenfeld_1982}{Coxmos}
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
