% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModFit.R
\name{ModFit}
\alias{ModFit}
\title{Node clustering and multiple change points detection on a dynamic graph.}
\usage{
ModFit(Gnu, kmin, kmax, eps = 10^(-9), iter.vem = 50,
  N_initializations = 1, MinimalPartition = TRUE,
  custom_partition = NULL, verbose = FALSE)
}
\arguments{
\item{Gnu}{A (3 x Nb.events) matrix. The first row contains the ordered interaction times, the second row the source nodes, the third row the destination nodes. Currently, only undirected interactions are taken into account. Thus, for each interaction time, the source node is stricly smaller than the destination node. No self loops allowed.}

\item{kmin}{A positive integer. The minimum number of clusters the BIC criterion will look for.}

\item{kmax}{A positive integer. The maximum number of clusters the BIC criterion will look for.}

\item{eps}{A small double. When the difference between two consecutive values of the variational lower bound is smaller than eps, the VEM algorithm stops.}

\item{iter.vem}{An integer. The maximum number of iterations the VEM algorithm will perform.}

\item{N_initializations}{An Integer. The number of different k-means initialisations to adopt.}

\item{MinimalPartition}{A Boolean. If TRUE (the default), the algorithm will look for change points among the time points in the first row of Gnu.}

\item{custom_partition}{A regular user defined partition. It is ignored if MinimalPartition is TRUE.}

\item{verbose}{A Boolean.}
}
\value{
\item{est_K}{An integer representing the detected number of clusters.}

\item{est_z}{An integer vector of length N (the number of nodes). The i-th entry of est_z is the estimated cluster of node i.}

\item{est_D}{An integer representing the detected number of segments.}

\item{est_cp}{A vector of doubles containing the D estimated change points (the last entry is equal to the last point of the partition).}

\item{est_Lbd}{ A (K x K x D) tensor. Its entries are the estimated non-homogeneous Poisson intensities.}

\item{est_pi}{A vector of length K containing the estimated mixing proportions.}
}
\description{
Node clustering and multiple change points detection on a dynamic graph.
}

\examples{
    data("Gnu")
    Th <- 10  # final time T
    step <- 0.1
    myptn <- seq(from = step, to = Th, by = step)
    kmin <- 3
    kmax <- 3
    res <- ModFit(Gnu, kmin, kmax, MinimalPartition = FALSE, custom_partition = myptn)  
}
